/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.ImmutableValue;

public class BooleanValue
extends ImmutableValue {
    private boolean value;
    public static final BooleanValue invalid = new BooleanValue();
    public static final BooleanValue falseValue = new BooleanValue(false);
    public static final BooleanValue trueValue = new BooleanValue(true);
    static FunctionTable functions = new StdFunctionTable(BooleanValue.getStandardFunctions());

    public static BooleanValue get(boolean bl) {
        return bl ? trueValue : falseValue;
    }

    private BooleanValue() {
        this.setInvalid();
    }

    private BooleanValue(boolean bl) {
        this.value = bl;
    }

    @Override
    public String getType() {
        return "boolean";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Boolean>>" : Boolean.toString(this.value);
    }

    @Override
    public boolean hasBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean(SourceRange sourceRange) {
        return this.value;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function1Arg("!", invalid, (value, sourceRange) -> BooleanValue.get(!value.getBoolean((SourceRange)sourceRange))));
        functions.add(new Function2Arg("==", invalid, (value, value2, sourceRange) -> BooleanValue.get(!value2.hasBoolean() ? false : value.getBoolean((SourceRange)sourceRange) == value2.getBoolean((SourceRange)sourceRange))));
        functions.add(new Function2Arg("!=", invalid, (value, value2, sourceRange) -> BooleanValue.get(!value2.hasBoolean() ? true : value.getBoolean((SourceRange)sourceRange) != value2.getBoolean((SourceRange)sourceRange))));
    }
}

